# Copyright 2020 Huawei Technologies Co., Ltd
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
# http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
# ============================================================================
import tensorflow as tf
from tensorflow.python.tools import freeze_graph
from tensorflow.python.framework import graph_util
import os, sys
base_path=os.path.split(os.path.realpath(__file__))[0]
sys.path.append(base_path + "/../")
from models.resnet50 import resnet,res50_helper
import argparse


def parse_args():
    parser = argparse.ArgumentParser(formatter_class=argparse.ArgumentDefaultsHelpFormatter)
    parser.add_argument('--ckpt_path', default=1,
                        help="""set checkpoint path""")
    args, unknown_args = parser.parse_known_args()
    if len(unknown_args) > 0:
        for bad_arg in unknown_args:
            print("ERROR: Unknown command line arg: %s" % bad_arg)
        raise ValueError("Invalid command line arg(s)")
    return args

def main():
    args = parse_args()
    tf.reset_default_graph()
    # set inputs node
    inputs = tf.placeholder(tf.float32, shape=[None, 224, 224, 3], name="input")
    # create inference graph
    with res50_helper.custom_getter_with_fp16_and_weight_decay(dtype= tf.float32, weight_decay=0.0001):
        builder = resnet.LayerBuilder(tf.nn.relu, 'channels_last', False, use_batch_norm=True,
                               conv_initializer=tf.variance_scaling_initializer(), bn_init_mode='adv_bn_init', bn_gamma_initial_value=1.0)
        logits = resnet.inference_resnet_v1_impl(builder, inputs, [3, 4, 6, 3], 'original', 'v1.5')

    with tf.Session() as sess:
        #save unfrozen graph
        tf.train.write_graph(sess.graph_def, './', 'model.pb')
        freeze_graph.freeze_graph(
                        input_graph='./model.pb',
                        input_saver='',
                        input_binary=False,
                        input_checkpoint=args.ckpt_path,
                        output_node_names='fp32_vars/final_dense',  # graph outputs node
                        restore_op_name='save/restore_all',
                        filename_tensor_name='save/Const:0',
                        output_graph='./resnet50_910.pb',   # output pb name
                        clear_devices=False,
                        initializer_nodes='')
    print("done")

if __name__ == '__main__':
    main()
